/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.util.List;
import javax.swing.JComponent;
import net.java.dev.designgridlayout.AbstractRow;
import net.java.dev.designgridlayout.BaselineHelper;
import net.java.dev.designgridlayout.HeightGrowPolicy;
import net.java.dev.designgridlayout.MarkerHelper;

final class LayoutHelper {
    private final HeightGrowPolicy _tester;
    private final int _parentWidth;
    private final boolean _rtl;
    private final List<AbstractRow> _rows;
    private int _availableHeight;
    private int _y;

    LayoutHelper(HeightGrowPolicy tester, int parentWidth, boolean rtl) {
        this(tester, parentWidth, rtl, null);
    }

    LayoutHelper(HeightGrowPolicy tester, int parentWidth, boolean rtl, List<AbstractRow> rows) {
        this._tester = tester;
        this._parentWidth = parentWidth;
        this._rtl = rtl;
        this._rows = rows;
    }

    void setRowAvailableHeight(int availableHeight) {
        this._availableHeight = availableHeight;
    }

    void setY(int y) {
        this._y = y;
    }

    void setHeight(int rowIndex, JComponent component, int spannedRows) {
        int availableHeight = 0;
        for (int i = 0; i < spannedRows; ++i) {
            AbstractRow row = this._rows.get(rowIndex + i);
            availableHeight += row.actualHeight();
            if (i + 1 >= spannedRows) continue;
            availableHeight += row.vgap();
        }
        int height = LayoutHelper.getComponentHeight(component);
        int usedExtraHeight = 0;
        if (MarkerHelper.isMarker(component)) {
            usedExtraHeight = availableHeight - height;
        } else if (this._tester.canGrowHeight(component)) {
            usedExtraHeight = this._tester.computeExtraHeight(component, availableHeight - height);
        }
        component.setSize(component.getWidth(), height + usedExtraHeight);
    }

    int setSizeLocation(JComponent component, int x, int width, int maxHeight, int maxBaseline) {
        int height = component.getPreferredSize().height;
        int usedExtraHeight = 0;
        if (this._tester.canGrowHeight(component)) {
            usedExtraHeight = this._tester.computeExtraHeight(component, this._availableHeight - height);
        }
        component.setSize(width, height + usedExtraHeight);
        int baseline = BaselineHelper.getBaseline(component);
        int yy = baseline > 0 ? maxBaseline - baseline : (baseline == 0 ? 0 : (maxHeight - height) / 2);
        component.setLocation(this._rtl ? this._parentWidth - x - width : x, this._y + yy);
        return usedExtraHeight;
    }

    private static int getComponentHeight(JComponent component) {
        int height = component.getHeight();
        return height > 0 ? height : component.getPreferredSize().height;
    }
}

